classdef invpendCartAnimator < handle
    
    properties
        X
        U
        lastPlot
        vecMovie
        param
        fig = NaN;
    end
    
    methods
        function obj = invpendCartAnimator(fig)
             if exist('fig','var')
                  obj.fig = fig;
             end
        end
        
        function animate(self, t, X, factor)
            if ~exist('factor','var')
                factor = 1;
            end
            if(factor<1)
                factor = 1;
                warning('factor has been clamped to 1. factor must be (factor>=1)!')
            end
            if ~isgraphics(self.fig)
                self.fig = figure();
            end

            x = X(:,1);
            th = X(:,2);
            
            tmp = x;          
            indx = [min(tmp)-4, max(tmp)+4];
            
            indy = [-4, 4];
                        
            N = length(x);
            
            P = [];
            hold on
            tmp = 1:factor:N;
            if tmp(end) ~= N
                tmp = [tmp, N];
            end
            
            for i = tmp
                delete(P);
                P = self.snapshot(x(i), th(i));
                title("Time = " + sprintf('%.2f',t(i)) + " sec")
                axis equal
                xlim(indx)
                ylim(indy)
                drawnow
                vec(i) = getframe(self.fig);
            end
            self.vecMovie = vec;
        end
        
        function animateInput(self, t, X, U, factor)
            if ~exist('factor','var')
                factor = 1;
            end
            if(factor<1)
                factor = 1;
                warning('factor has been clamped to 1. factor must be (factor>=1)!')
            end
            if ~isgraphics(self.fig)
                self.fig = figure();
                self.fig.Position = [100 100 1000 400];
            end

            x = X(:,1);
            th = X(:,2);
            
            tmp = x;          
            indx = [min(tmp)-4, max(tmp)+4];
            
            indy = [-4, 4];
                        
            N = length(x);
            
            P = [];
            hold on
            tmp = 1:factor:N;
            if tmp(end) ~= N
                tmp = [tmp, N];
            end
            y_ulim = [min(U)-1, max(U)+1];
            k = 1;
            for i = tmp
                
                delete(P);
                subplot(1,2,1)
                P = self.snapshot(x(i), th(i));
                view(2)
                title("Time = " + sprintf('%.2f',t(i)) + " sec")
                axis equal
                xlim(indx)
                ylim(indy)
                drawnow
                
                subplot(1,2,2)
                hold on
                Pu = plot(t(k:i), U(k:i), 'color', '[0.9290, 0.6940, 0.1250]');
                xlabel('Time (sec)')
                ylabel('$u(t)$')
%                 axis equal
                xlim([t(1), t(end)])
                ylim(y_ulim)
                drawnow
                
                vec(i) = getframe(self.fig);
                k = i;
            end
            self.vecMovie = vec;
        end

        function PP = snapshot(self, x, th, ax)
            if ~exist('ax', 'var')
                ax = gca;
            end

            PP = [];
            lc = 3;
            L = 4;
            xc = [x - lc/2, x + lc/2];
            yc = [-0.5, 0.5];
            [xc,yc] = meshgrid(xc,yc);

            xp1 = x;
            xp2 = x + L*sin(th);
            yp1 = 0;
            yp2 = -L*cos(th);
            tmp1 = surf(xc, yc, zeros(2), 'facecolor', '[0, 0.4470, 0.7410]', 'parent', ax);
            hold on
            tmp2 = plot([xp1, xp2], [yp1, yp2], 'linewidth', 5, 'color', 'red', 'parent', ax);
            tmp3 = plot(xp2, yp2, 'blacko', 'markersize', 15, 'markerfacecolor', 'red', 'parent', ax);
            PP = [tmp1, tmp2, tmp3];
        end
        
        function exportMovie(self, txt, fr)
            num = length(self.vecMovie);
            
            for i = 1:(num+10)
                if i <= 10
                    vec(i) = self.vecMovie(1);
                else
                    vec(i) = self.vecMovie(i-10);
                end
            end
%             myWriter = VideoWriter(txt, 'MPEG-4');
            myWriter = VideoWriter(txt);
            myWriter.FrameRate = fr;
            
            open(myWriter);
            writeVideo(myWriter, vec);
            close(myWriter)
        end
    end
end

