%============================== mainIPCart =============================
%
% Code stub for inverted pendulum on a cart. Demonstrates basic
% functionality of the associated classes.
%
% The controller is set to be an anonymous function for provision of
% executable code.  It should be remapped to a better function that
% implements some form of feedback or error feedback control.  In some
% cases, an anonymous function will suffice.  For implementation of
% adaptive control laws, this function may have to parse the state x and
% unpack it to synthesize the control law.  Such synthesis might also
% include the adaptive laws.
%
% It should even be possible to define the control law as a member function
% of the invpendCart class.  Consider how to best augment this implementation 
% with an adaptive controller.  It might be by creating a sub-class with
% this expanded functionality and larger state size, or it might be by
% adding in new member functions.  Up to you. Just be clean about it.
%

if (~exist('prettyup') || prettyup) % If prettyup should be done, do so.
  clearEnv;
  prettyup = false;                 % Don't pretty up/clear environment.
end                                 % otherwise, environment stays as is.
                                    % Affect repeat runs. Set as you please.

robo = invpendCart();
u = @(t,x) 19.0;

x0    = [0;pi*0.9; 0; 0];
tspan = [0, 2];
[tSim, xSim, xdotSim, uSim] = robo.runSim(tspan, x0, u);

ani = invpendCartAnimator(figure(1));
ani.animateInput(tSim, xSim, uSim)

ani.fig  = figure(2);
ani.animate(tSim, xSim)

% ani.exportMovie('invpencart', 15)


