%============================== invpendCart ==============================
%
% Functional code stub for the inverted pendulum on a cart project.  The
% dynamics and parameters don't exactly agree with the specification in the
% wiki.  That's OK.  This is just to provide some sort of functional baseline
% implementation from which to work from.
%
classdef invpendCart < handle
    
    properties
        param = struct('g',         9.8,...
                       'm_cart',    5,...
                       'm_ball',    1,...
                       'L',         1)
        
        tSim
        xSim            % states are x, th, dx, dth
        xdotSim
        uSim
        
        % Most likely useful for other implementations. Think through how
        % coding design permits the different versions to easily run.
        %A
        %B
        %P
        %Klqr
    end
    
    methods

        %========================= invpendCart =========================
        %
        % Constructor for the inverted pendulum on a cart instance.
        %
        function obj = invpendCart(param)
             if exist('param','var')
                  obj.param = param;
             end
        end
        
        %============================ runSim ===========================
        %
        % Abstracted interface to run the simulation of the inverted
        % pendulum on a cart. Uses a format similar to odeXX functions
        % for specifying the initial value problem (IVP) with the addition
        % of a control function.
        %
        function [tSim, xSim, xdotSim, uSim] = runSim(self, tspan, x0, u)
            sys = @(t,x) self.dynamics(t, x, u);

            % Simulate the system.
            [tSim, xSim] = ode45(sys, tspan, x0);

            % Use simulation data to recover controls and diff eq.
            % Data is row-wise.
            num     = length(tSim);
            uSim    = zeros(num,1);
            xdotSim = zeros(size(xSim));
            
            for i = 1:num
                x = xSim(i,:)';
                t = tSim(i);
                uSim(i) = u(t, x);
                xdotSim(i,:) = self.dynamics(t, x, u)';
            end
            
            % Store variables in case needed for later.
            self.tSim = tSim;
            self.xSim = xSim;
            self.xdotSim = xdotSim;
            self.uSim = uSim;
        end
        
        %=========================== dynamics ==========================
        %
        % Compute the dynamics of the system under the applied control.
        %
        function xdot = dynamics(self, t, x, u)
            xk = x(1); th = x(2); dx = x(3); dth = x(4);
            g = self.param.g;
            m_cart = self.param.m_cart; m_ball = self.param.m_ball; L = self.param.L;
            
            dx1 = x(3);
            dx2 = x(4);
            dx3 = ( m_ball*sin(th)*(L*dth^2+g*cos(th)) + u(t,x) ) ...
                                                 / ( m_cart+m_ball*sin(th)^2 );
            dx4 = -( (m_cart+m_ball)*g*sin(th)+m_ball*L*dth^2*sin(th)*cos(th) ...
                              + u(t,x)*cos(th) ) ...
                                                 / ( (m_cart+m_ball*sin(th)^2)*L );
            
            xdot = [dx1; dx2; dx3; dx4];
        end
        
        %========================== linearize ==========================
        %
        % Returns the linearized system equations for use by control
        % synthesis or model reference schemes.
        %
        function [A,B] = linearize(self, x0, u0)

          % TO BE FILLED OUT IF WORTH DOING.

        end
    end
end
