%============================== mainBirotor ==============================
%
% Code stub for the birotor project. Demonstrates basic functionality of
% the associated classes.
%
% The controller is set to be an anonymous function for provision of
% executable code.  It should be remapped to a better function that
% implements some form of feedback or error feedback control.  In some
% cases, an anonymous function will suffice.  For implementation of
% adaptive control laws, this function may have to parse the state x and
% unpack it to synthesize the control law.  Such synthesis might also
% include the adaptive laws.
%
% It should even be possible to define the control law as a member function
% of the ductedfan class.  Consider how to best augment this implementation 
% with an adaptive controller.  It might be by creating a sub-class with
% this expanded functionality and larger state size, or it might be by
% adding in new member functions.  Up to you. Just be clean about it.
%

if (~exist('prettyup'))
  prettyup = true;                  % Should environment be cleared out?
end                                 % Affects repeat runs. Set as you please.

if (prettyup)                       % If prettyup should be done, do so.
  clearEnv;
  prettyup = true;                  
end                                 % otherwise, environment stays as is.

g = 9.81;

robo = birotor();

u = @(t,x) robo.param.m*g*[1.001;1.0005]/2;
x0 = [-0.5;0.2;0; 0;0;0];           % Lame initial condition.

tspan = [0,2];
[tSim, xSim, dxSim, uSim] = robo.runSim(tspan, x0, u);

ani = birotorAnimator();

ani.fig = figure(1); clf;
ani.newDrawing();
ani.animateInput(tSim, xSim, uSim, 4);

ani.fig = figure(2); clf;
ani.newDrawing();
ani.animate(tSim, xSim);

