%=============================== surface03 ===============================
%
% @brief    Script to process of surface mesh of a hyperbolic point cloud.
%
% A script that creates a hyperbolic surface and the applies the
% triangulation code.
%
%=============================== surface03 ===============================

%
% @ingroup  pointClouds
%
% @file     surface03.m
%
% @author   Patricio A. Vela,       pvela@gatech.edu
% @date     2017/02
%
% @quit
%=============================== surface03 ===============================

%====[0] Load data.
%
load meshPoints.mat;

%====[1] Create hyperbolic surface.
%
ppts = pts3D(rawXXXXX);

axLims = [0 10 0 10 0 20];              % Change as needed to view nicely.
                                        %  Currently too big I think.

figure(1);
  clf;
  ppts.plot();
  axis equal;
  axis(axLims);                         % Set reasonable axes limits.
  drawnow();

%====[2] Triangulate the surface.
%

rho.near  = XXXXX;                        % Proximity radius.
rho.noise = YYYYY;                       % Numerical error fudge tolerance.

[triVerts, inPlay] = genMesh(ppts, rho);

dtri = triangulation(triVerts, ppts.pts.Location);

%====[3] Plot the points and the triangulated mesh.
%
cols = [200 , 100, 100 ; 50, 50, 200];  % Color by in play/out of play.
scol = cols(inPlay+1,:);                % Helps visualize if code working.
ppts.setColor(scol);                    % All triangle interior points
                                        % should be red.

figure(1);
  clf;
  ppts.plot();                          % Plot the points.
  axis equal;
  axis(axLims);                         % Set reasonable axes limits.
  hold on;
    trimesh(dtri);                      % Plot the surface mesh.
  hold off;
  xlabel('x'); 
  ylabel('y');
  zlabel('z');

%
%=============================== surface03 ===============================
