%================================ Biped ===============================
%
% @class    Biped
%
% @brief    Bipedal robot model & supporting utilities
%
%
%  Skeleton code with stub'd out functions - to be completed as part of
%  ECE 4560 weekly course assignments.
%
%  Note: Should utilize SE2 Matlab class
%
%================================ Biped ===============================

%
% @file     Biped.m
%
% @author   Alex H. Chang,   alexander.h.chang@gatech.edu
% @date     2018/09/26 [modified]
%
% @note
%   set indent to 2 spaces.
%   set tab to 4 spaces, with conversion.
%
%================================ Biped ===============================

classdef Biped < handle
  
  properties
    gRO = [];        % biped world frame
    
    alpha = [];      % current joint configuration
    geom = [];       % link lengths (mm)
    stance = '';     % reference frame
    
  end
  
  %
  %
  %============================ Member Functions ==========================
  %
  %
  methods
    
    %------------------------------ Biped ------------------------------
    %
    %  Constructor
    %
    function obj = Biped()
      
      obj.gRO = SE2([0; 0], 0);
      obj.stance = 'TORSO';
      
    end
    
    %------------------------- set_geometry ----------------------------
    %
    %
    function set_geometry( obj, a_geom )
      % TO DO: set biped link lengths based on input
    end
    
    %---------------------------- set_alpha ----------------------------
    %
    % set_alpha(a_alpha)
    %
    % Sets the joint configuration for the biped.
    %
    function set_alpha( obj, a_alpha )
      % TO DO: set biped joint configuration based on input      
    end
    
    %----------------------------- plotTf ------------------------------
    %
    % plotTF()
    %
    % Plot the torso frame, both foot frames and all links, consistent
    % with the biped's current joint configuration and link lengths.
    %
    function plotTF( obj )
      % TO DO: Plot stick figure model of biped as well as Torso, Left Foot
      %         and Right Foot frames
    end
    
    %-------------------------- fwd_kinematics -------------------------
    %
    %    Computes Biped forward kinematics based on current joint
    %    configuration and link lengths
    %
    %    Output:
    %       frame_se2_poses - cell array of SE2 objects
    %
    function [ frame_se2_poses ] = fwd_kinematics( obj )
      % TO DO: Compute forward kinematics to obtain pose of each frame
      %         rigidly attached to a biped link (output as cell array)
      frame_se2_poses = {};
    end
    
  end     % methods
end

